/*************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#if defined(_MSC_VER) && !defined(__INTEL_COMPILER)
#pragma warning(disable : 4206) // empty translation unit in MSVC
#endif

/* Selftests are disabled for now, since rsa 1k scheme is not FIPS-approved */
#if 0

#ifdef MBX_FIPS_MODE

#include <crypto_mb/fips_cert.h>
#include <internal/fips_cert/common.h>
#include <internal/rsa/ifma_rsa_method.h>

#include <crypto_mb/rsa.h>

/* KAT TEST (generated via internal tests) */
/* plaintext */
static const int8u plaintext[MBX_RSA1K_DATA_BYTE_LEN]  = {
  0xc5,0x87,0x62,0x86,0x7f,0x60,0xa1,0x20,0xd1,0x8c,0x60,0xf6,0x9a,0xd5,0x5b,0x43,
  0x19,0x53,0xb9,0xb0,0x67,0xe6,0xb3,0x3b,0xd1,0x03,0x73,0x13,0x3e,0x25,0x20,0x47,
  0x44,0x9f,0xaa,0x6c,0xca,0x57,0xfd,0xcf,0xfd,0x2b,0x33,0x9b,0xb5,0x4f,0x4c,0xde,
  0x59,0x0a,0x7d,0xcb,0x80,0x47,0x6d,0x54,0x59,0x0e,0x2b,0x8b,0x43,0x19,0x43,0x7d,
  0x05,0x2d,0xd6,0x55,0xfe,0x08,0xe2,0x4f,0xda,0xae,0xf4,0xc1,0x3f,0x6e,0x61,0x30,
  0xc4,0xe6,0x02,0x36,0xfc,0xa7,0xbe,0xc5,0xff,0xdc,0xd0,0xe4,0x5e,0x27,0x32,0xa5,
  0xa9,0xde,0xca,0xd3,0x2d,0xaa,0x3f,0x7a,0x61,0x3f,0x6e,0xf7,0xf1,0x27,0xda,0x3a,
  0xd5,0x71,0x4f,0xf1,0xbf,0x2f,0xbb,0xa8,0x89,0xa1,0x06,0xad,0x73,0xd4,0x63,0x7d};
/* ciphertext */
static const int8u ciphertext[MBX_RSA1K_DATA_BYTE_LEN] = {
  0x91,0x43,0x4f,0x37,0xcb,0xf8,0x26,0xa6,0x74,0x2c,0xb9,0x9c,0x8b,0x09,0xfe,0x01,
  0x1f,0x3a,0x01,0xc5,0x1f,0xeb,0xd9,0xea,0xc7,0x8f,0xcb,0x4d,0xf3,0xfb,0xef,0xf3,
  0x73,0xe9,0xcf,0x16,0x8d,0xaf,0x05,0x60,0xd2,0x72,0x45,0xb1,0xc9,0xcd,0xb3,0x07,
  0xdc,0x3f,0x81,0x2e,0x96,0x63,0xe7,0xf2,0xc4,0x92,0x6e,0x96,0xfd,0x62,0x5d,0x6f,
  0xac,0xa5,0x2c,0x2e,0x21,0x91,0xe2,0xe1,0xb5,0x9a,0xb3,0xf7,0xc3,0x0c,0x1c,0x2f,
  0x84,0xea,0x1d,0xe8,0xc7,0xc3,0x5b,0xb6,0x1a,0x3c,0x0d,0x22,0xc0,0x23,0x2b,0xa2,
  0xb0,0x0a,0x7e,0x36,0x35,0x99,0xce,0x0d,0x0a,0xdf,0x34,0x9f,0xae,0x44,0x49,0xdb,
  0x4e,0x8d,0x8a,0x7a,0x57,0xda,0xf0,0x9b,0x53,0x94,0x29,0xf0,0x3a,0x62,0x01,0x6f};
/* p, q primes */
static const int8u p[MBX_RSA1K_DATA_BYTE_LEN / 2] = {
  0xb9,0x09,0x65,0xa8,0xc9,0xa3,0xa4,0x03,0x57,0xec,0x9f,0x1b,0xc1,0x6d,0xee,0xb8,
  0x49,0xf0,0xf7,0x81,0xbc,0x75,0x43,0x34,0xdf,0x66,0xa3,0xeb,0xb7,0xab,0x83,0x57,
  0x66,0x73,0xee,0x2f,0x82,0x95,0x18,0x10,0xaa,0xe9,0x9e,0x65,0xf7,0xca,0xe4,0x9a,
  0x9d,0xc3,0xbd,0xe7,0xb5,0xd4,0xf0,0xf2,0x78,0xae,0x7f,0x0f,0xa4,0xea,0x9a,0xef};
static const int8u q[MBX_RSA1K_DATA_BYTE_LEN / 2] = {
  0x53,0xc9,0x40,0x13,0x28,0x8a,0xf4,0x5c,0xf1,0xfa,0x6e,0xba,0xf0,0x5a,0x77,0x2c,
  0x8c,0xa5,0x89,0xea,0xa4,0xd7,0x15,0x6d,0x75,0x63,0xaf,0xd3,0x5b,0x47,0x81,0x42,
  0xff,0x0c,0x79,0x34,0x28,0x50,0xa1,0xf5,0x54,0x7e,0x78,0xcc,0x82,0x4f,0xb3,0x45,
  0x43,0x82,0x94,0x98,0xb0,0xe7,0x8b,0x0f,0x4a,0xb4,0x35,0x15,0xdb,0xce,0x51,0xdc};
/* p's, q's CRT private exponent */
static const int8u dp[MBX_RSA1K_DATA_BYTE_LEN / 2] = {
  0xd1,0x4f,0x50,0x2e,0x22,0xdb,0xbb,0x19,0xe1,0x1f,0x4b,0x28,0xee,0xf6,0xfb,0xc2,
  0x90,0x46,0x4c,0x02,0xd6,0x27,0x75,0xc3,0x5d,0x5a,0x66,0x8f,0x47,0x1c,0x49,0xf1,
  0x51,0x47,0x11,0xf1,0x94,0xc3,0xf0,0x16,0xec,0x6d,0x4b,0xe9,0xb2,0xf7,0xb5,0x0b,
  0x42,0xd6,0xb9,0x9e,0x31,0xba,0xf7,0x62,0xd5,0xe5,0x91,0xce,0xcd,0xca,0xd7,0xbd};
static const int8u dq[MBX_RSA1K_DATA_BYTE_LEN / 2] = {
  0x8b,0xd9,0x78,0x8c,0xa0,0xd7,0x4a,0x19,0xb0,0xbc,0x0f,0xea,0x5b,0xa5,0x12,0x28,
  0xd6,0xea,0x95,0x7f,0x23,0x5c,0x87,0x4b,0xbb,0xa7,0x10,0xbc,0x57,0x78,0xd3,0xed,
  0x36,0x7e,0x33,0x9e,0xc7,0xfb,0x19,0x2b,0x31,0x03,0x60,0x2f,0x1d,0x2c,0xe7,0x4f,
  0x19,0xa0,0x12,0xd4,0x10,0x9d,0x86,0xa7,0xcb,0xce,0x1b,0x70,0x9b,0xa0,0x45,0x34};
/* CRT coefficient */
static const int8u inv_q[MBX_RSA1K_DATA_BYTE_LEN / 2]  = {
  0x33,0x50,0x88,0x58,0x0f,0x2d,0x9a,0x01,0x7d,0xd5,0x10,0xcb,0x1d,0x76,0xd4,0x67,
  0xd1,0xac,0x69,0x9a,0x56,0xea,0x6e,0xbf,0x90,0x1e,0x9a,0x4e,0xcd,0x2a,0x20,0x28,
  0xec,0xa0,0x8b,0xaf,0x43,0xba,0xd0,0x73,0x8f,0xf3,0xbb,0xc3,0x6c,0xe0,0xa3,0x82,
  0x5f,0x46,0x50,0xba,0xc9,0x01,0x6c,0x97,0xfe,0x78,0x68,0x33,0xad,0x90,0xad,0x11};

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa1k_private_crt_mb8(void) {
  fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

  /* output plaintext */
  int8u out_plaintext[MBX_LANES][MBX_RSA1K_DATA_BYTE_LEN];
  /* key operation */
  const mbx_RSA_Method* method = mbx_RSA1K_private_crt_Method();

  /* function input parameters */
  // ciphertext
  const int8u *pa_ciphertext[MBX_LANES] = {
    ciphertext, ciphertext, ciphertext, ciphertext,
    ciphertext, ciphertext, ciphertext, ciphertext};
  // plaintext
  int8u *pa_plaintext[MBX_LANES] = {
    out_plaintext[0], out_plaintext[1], out_plaintext[2], out_plaintext[3],
    out_plaintext[4], out_plaintext[5], out_plaintext[6], out_plaintext[7]};
  // p, q primes
  const int64u *pa_p[MBX_LANES]= {
    (int64u *)p, (int64u *)p, (int64u *)p, (int64u *)p,
    (int64u *)p, (int64u *)p, (int64u *)p, (int64u *)p};
  const int64u *pa_q[MBX_LANES]= {
    (int64u *)q, (int64u *)q, (int64u *)q, (int64u *)q,
    (int64u *)q, (int64u *)q, (int64u *)q, (int64u *)q};
  /* p's, q's CRT private exponent */
  const int64u *pa_dp[MBX_LANES]= {
    (int64u *)dp, (int64u *)dp, (int64u *)dp, (int64u *)dp,
    (int64u *)dp, (int64u *)dp, (int64u *)dp, (int64u *)dp};
  const int64u *pa_dq[MBX_LANES]= {
    (int64u *)dq, (int64u *)dq, (int64u *)dq, (int64u *)dq,
    (int64u *)dq, (int64u *)dq, (int64u *)dq, (int64u *)dq};
  /* CRT coefficient */
  const int64u *pa_inv_q[MBX_LANES]= {
    (int64u *)inv_q, (int64u *)inv_q, (int64u *)inv_q, (int64u *)inv_q,
    (int64u *)inv_q, (int64u *)inv_q, (int64u *)inv_q, (int64u *)inv_q};

  /* test function */
  mbx_status expected_status_mb8 = MBX_SET_STS_ALL(MBX_STATUS_OK);

  mbx_status sts;
  sts = mbx_rsa_private_crt_mb8(pa_ciphertext, pa_plaintext, pa_p, pa_q, pa_dp, pa_dq, pa_inv_q,
    MBX_RSA1K_DATA_BIT_LEN, method, NULL);
  if (expected_status_mb8 != sts) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
  }
  // compare output plaintext to known answer
  int output_status;
  for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
    output_status = mbx_is_mem_eq(pa_plaintext[i], MBX_RSA1K_DATA_BYTE_LEN, plaintext, MBX_RSA1K_DATA_BYTE_LEN);
    if (!output_status) { // wrong output
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }

  return test_result;
}

#ifndef BN_OPENSSL_DISABLE

// memory free macro
#define MEM_FREE(BN_PTR1, BN_PTR2, BN_PTR3, BN_PTR4, BN_PTR5) \
    {                                                         \
        BN_free(BN_PTR1);                                     \
        BN_free(BN_PTR2);                                     \
        BN_free(BN_PTR3);                                     \
        BN_free(BN_PTR4);                                     \
        BN_free(BN_PTR5);                                     \
    }

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa1k_private_crt_ssl_mb8(void) {

  fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

  /* output plaintext */
  int8u out_plaintext[MBX_LANES][MBX_RSA1K_DATA_BYTE_LEN];
  /* ssl parameters */
  // p, q primes
  BIGNUM* BN_p  = BN_new();
  BIGNUM* BN_q  = BN_new();
  // p's, q's CRT private exponent
  BIGNUM* BN_dp = BN_new();
  BIGNUM* BN_dq = BN_new();
  // CRT coefficient
  BIGNUM* BN_inv_q = BN_new();
  /* check if allocated memory is valid */
  if(NULL == BN_p || NULL == BN_q || NULL == BN_dp || NULL == BN_dq || NULL == BN_inv_q) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
    MEM_FREE(BN_p, BN_q, BN_dp, BN_dq, BN_inv_q)
    return test_result;
  }

  /* function status and expected status */
  mbx_status sts;
  mbx_status expected_status_mb8 = MBX_SET_STS_ALL(MBX_STATUS_OK);
  /* output validity status */
  int output_status;

  /* set ssl parameters */
  BN_lebin2bn(p, MBX_RSA1K_DATA_BYTE_LEN / 2, BN_p);
  BN_lebin2bn(q, MBX_RSA1K_DATA_BYTE_LEN / 2, BN_q);
  BN_lebin2bn(dp, MBX_RSA1K_DATA_BYTE_LEN / 2, BN_dp);
  BN_lebin2bn(dq, MBX_RSA1K_DATA_BYTE_LEN / 2, BN_dq);
  BN_lebin2bn(inv_q, MBX_RSA1K_DATA_BYTE_LEN / 2, BN_inv_q);

  /* function input parameters */
  // ciphertext
  const int8u *pa_ciphertext[MBX_LANES] = {
    ciphertext, ciphertext, ciphertext, ciphertext,
    ciphertext, ciphertext, ciphertext, ciphertext};
  // plaintext
  int8u *pa_plaintext[MBX_LANES] = {
    out_plaintext[0], out_plaintext[1], out_plaintext[2], out_plaintext[3],
    out_plaintext[4], out_plaintext[5], out_plaintext[6], out_plaintext[7]};
  // p, q primes
  const BIGNUM *pa_p[MBX_LANES] = {
    (const BIGNUM *)BN_p, (const BIGNUM *)BN_p, (const BIGNUM *)BN_p, (const BIGNUM *)BN_p,
    (const BIGNUM *)BN_p, (const BIGNUM *)BN_p, (const BIGNUM *)BN_p, (const BIGNUM *)BN_p};
  const BIGNUM *pa_q[MBX_LANES] = {
    (const BIGNUM *)BN_q, (const BIGNUM *)BN_q, (const BIGNUM *)BN_q, (const BIGNUM *)BN_q,
    (const BIGNUM *)BN_q, (const BIGNUM *)BN_q, (const BIGNUM *)BN_q, (const BIGNUM *)BN_q};
  // p's, q's CRT private exponent
  const BIGNUM *pa_dp[MBX_LANES] = {
    (const BIGNUM *)BN_dp, (const BIGNUM *)BN_dp, (const BIGNUM *)BN_dp, (const BIGNUM *)BN_dp,
    (const BIGNUM *)BN_dp, (const BIGNUM *)BN_dp, (const BIGNUM *)BN_dp, (const BIGNUM *)BN_dp};
  const BIGNUM *pa_dq[MBX_LANES] = {
    (const BIGNUM *)BN_dq, (const BIGNUM *)BN_dq, (const BIGNUM *)BN_dq, (const BIGNUM *)BN_dq,
    (const BIGNUM *)BN_dq, (const BIGNUM *)BN_dq, (const BIGNUM *)BN_dq, (const BIGNUM *)BN_dq};
  // CRT coefficient
  const BIGNUM *pa_inv_q[MBX_LANES] = {
    (const BIGNUM *)BN_inv_q, (const BIGNUM *)BN_inv_q, (const BIGNUM *)BN_inv_q, (const BIGNUM *)BN_inv_q,
    (const BIGNUM *)BN_inv_q, (const BIGNUM *)BN_inv_q, (const BIGNUM *)BN_inv_q, (const BIGNUM *)BN_inv_q};

  /* test function */
  sts = mbx_rsa_private_crt_ssl_mb8(pa_ciphertext, pa_plaintext,
    pa_p, pa_q, pa_dp, pa_dq, pa_inv_q, MBX_RSA1K_DATA_BIT_LEN);
  if (expected_status_mb8 != sts) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
  }
  // compare output signature to known answer
  for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
    output_status = mbx_is_mem_eq(pa_plaintext[i], MBX_RSA1K_DATA_BYTE_LEN, plaintext, MBX_RSA1K_DATA_BYTE_LEN);
    if (!output_status) { // wrong output
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }

  // memory free
  MEM_FREE(BN_p, BN_q, BN_dp, BN_dq, BN_inv_q)

  return test_result;
}

#endif // BN_OPENSSL_DISABLE
#endif // MBX_FIPS_MODE
#endif // #if 0
